%% Import data from spreadsheet
% Script for importing data from the following spreadsheet:
%
%    Workbook: /Users/emilybarker/OneDrive - University of Southampton/D9.2 Uncertainty in Scenarios Tech Report/D9.2-Open Source Data/Data/data.xlsx
%    Worksheet: Aut
%
% To extend the code for use with different selected data or a different
% spreadsheet, generate a function instead of a script.

% Auto-generated by MATLAB on 2021/10/19 09:37:00

%% Import the data
raw = raw(2:end,:);
raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
stringVectors = string(raw(:,1));
stringVectors(ismissing(stringVectors)) = '';
raw = raw(:,[2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60]);

%% Replace non-numeric cells with NaN
R = cellfun(@(x) ~isnumeric(x) && ~islogical(x),raw); % Find non-numeric cells
raw(R) = {NaN}; % Replace non-numeric cells

%% Create output variable
data = reshape([raw{:}],size(raw));

%% Allocate imported array to column variable names
TQ = stringVectors(:,1);
nmquart = data(:,1);
GDP = data(:,2);
Unemp = data(:,3);
WageSal = data(:,4);
WagePre = data(:,5);
Emp = data(:,6);
Fbalquart = data(:,7);
GovPurquart = data(:,8);
NetTaxquart = data(:,9);
TaxRevquart = data(:,10);
NetFLquart = data(:,11);
Transquart = data(:,12);
GDPPCquart = data(:,13);
Cons = data(:,14);
Invest = data(:,15);
NX = data(:,16);
lnWageSal = data(:,17);
lnWagePre = data(:,18);
lnGovPurq = data(:,19);
lnNetTaxq = data(:,20);
lnTaxRevq = data(:,21);
lnTransq = data(:,22);
lnGDPPCq = data(:,23);
lnImmigq = data(:,24);
lnEmigq = data(:,25);
lnNMq = data(:,26);
lnImmigAggq = data(:,27);
lnEmigAggq = data(:,28);
lnNMAggq = data(:,29);
Immigquart = data(:,30);
Emigquart = data(:,31);
NMq = data(:,32);
ImmigAggq = data(:,33);
EmigAggq = data(:,34);
NMAggq = data(:,35);
NetFLqpc = data(:,36);
netemig = data(:,37);
lnnetemig = data(:,38);
netemigagg = data(:,39);
lnnetemigagg = data(:,40);
CmnMkt = data(:,41);
CmnMktGR = data(:,42);
TtlMkt = data(:,43);
TtlMktGR = data(:,44);
EU10 = data(:,45);
A8 = data(:,46);
EU2 = data(:,47);
lnCmnMkt = data(:,48);
lnTtlMkt = data(:,49);
lnCmnMktpc = data(:,50);
Emp2 = data(:,51);
WagePrepc = data(:,52);
GDP_EU27 = data(:,53);
GDP_EU14 = data(:,54);
WS_EU27 = data(:,55);
WS_EU14 = data(:,56);
lnEmigMkt = data(:,57);
lnEmigMktpc = data(:,58);
MigCris = data(:,59);
Emp=Emp2;
%% Clear temporary variables
clearvars data raw stringVectors R;

T = table(TQ,nmquart,GDP,Cons,Invest,Unemp,Emp,lnWageSal,WagePre,lnGovPurq,lnNetTaxq,lnTaxRevq,lnTransq,lnEmigq,lnImmigq,lnNMq,Immigquart,Emigquart,NMq,NetFLqpc,netemig,lnCmnMktpc) ;


%T=table2cell(T);